<?php
// Minimal template engine for ksphpplus (auto-converted)
class SimpleTpl {
    protected $vars = [];
    protected $baseDir;
    public function __construct($baseDir = null) {
        $this->baseDir = $baseDir ?? __DIR__ . '/templates_simple';
    }
    public function assign($key, $val) {
        $this->vars[$key] = $val;
    }
    public function assignArray($arr) {
        if (is_array($arr)) foreach ($arr as $k=>$v) $this->vars[$k] = $v;
    }
    // displayParsedTemplate('name') will include name.html from templates dir
    public function displayParsedTemplate($name) {
        $file = $this->baseDir . '/' . $name . '.html';
        if (!file_exists($file)) {
            // fallback: try name.tmpl.html or name.tmpl
            foreach (['.tmpl.html','.tmpl'] as $ext) {
                if (file_exists($this->baseDir.'/'.$name.$ext)) { $file = $this->baseDir.'/'.$name.$ext; break; }
            }
        }
        if (!file_exists($file)) {
            echo "<!-- template not found: ".htmlspecialchars($name)." -->";
            return;
        }
        // extract variables and include
        extract($this->vars);
        include $file;
    }
    public function get($key, $default='') {
        return $this->vars[$key] ?? $default;
    }
}
?>