<?php
/*********************************************
  PHPあぷろだ               by ToR
  http://php.s3.to
  http://php.loglog.jp/
  source by ずるぽん
  http://zurubon.virtualave.net/

  2001/08/30
  2001/09/04 v1.1 クッキーで環境設定、FTP転送（削除はまだ
　2002/06/12 v1.2 move_uploaded_fileに変更（215行
  2002/07/23 v1.3 del=のCSS対策(147行
  2002/08/06 v2.0 仕様ちょと変える(許可拡張子、元ファイル名表示
  2004/10/10 v2.2 もろもろ修正
  2005/01/10 v2.3 改行削除
 *********************************************/
/*
  20251109 v2.4 php8.2対応のChatGPT による改修バージョン（擬古猫）
*/
// ===== PHP8.2対応 修正開始 ====================================

// get_magic_quotes_gpc() は削除されたため、常に false とする
if (!function_exists('get_magic_quotes_gpc')) {
    function get_magic_quotes_gpc() { return false; }
}

// $_FILES['upfile'] が存在しない場合の対策
$has_upfile = isset($_FILES['upfile']);

// ===============================================================

if (phpversion() >= "8.2.0") { // PHP8.2.0以降対応
    $_GET  = array_map(fn($v) => _clean($v), $_GET);
    $_POST = array_map(fn($v) => _clean($v), $_POST);
    extract($_GET);
    extract($_POST);
    extract($_COOKIE);
    extract($_SERVER);

    // PHP8.2対応: $_FILES['upfile'] の存在確認
    if ($has_upfile) {
        $upfile_type = _clean($_FILES['upfile']['type'] ?? '');
        $upfile_size = $_FILES["upfile"]["size"] ?? 0;
        $upfile_name = _clean($_FILES["upfile"]["name"] ?? '');
        $upfile      = $_FILES["upfile"]["tmp_name"] ?? '';
    } else {
        $upfile_type = $upfile_name = $upfile = '';
        $upfile_size = 0;
    }
}

$logfile   = "upup.log";   //ログファイル名（変更する事）
$updir     = "./upload/";  //アップ用ディレクトリ
$prefix    = 'zt';         //接頭語
$logmax    = 100;          //log保存行
$commax    = 250;          //コメント投稿量制限
$limitk    = 3000;         //アップロード制限（KB）
$page_def  = 20;           //一ページの表示行数
$admin     = "1234";       //削除管理パス
$auto_link = 1;            //コメントの自動リンク
$denylist  = ['192.168.0.1','sex.com','annony']; //アクセス拒否ホスト
$arrowext  = ['jpeg','jpg','pdf','png','gif','mp4','3gp','amc','mld','phps','zip']; //許可拡張子

$count_start = "2018/10/06"; //カウンタ開始日
$count_file  = "count.txt";  //カウンタファイル（空ファイルで666）

$last_file = "last.cgi"; //連続投稿制限用ファイル
$last_time = 1;          //同一IPからの連続投稿許可間隔（分）

/* 項目表示（環境設定）の初期状態 */
$f_act  = 'checked';
$f_com  = 'checked';
$f_size = 'checked';
$f_mime = '';
$f_date = 'checked';
$f_anot = 'checked';
$f_orig = 'checked';

if ($act == "envset") {
    $cookval = implode(",", [$acte, $come, $sizee, $mimee, $datee, $anote, $orige]);
    setcookie("upcook", $cookval, ['expires' => time() + 365 * 24 * 3600]);
}

// ==== PHP8.2対応: _clean 修正版 ====
function _clean($str)
{
    if (is_array($str)) {
        return array_map('_clean', $str);
    }
    $str = htmlspecialchars((string)$str, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
    // get_magic_quotes_gpc() は常に false
    return $str;
}
/* ここからヘッダー */
?>
<HTML>
<HEAD><META HTTP-EQUIV="Content-type" CONTENT="text/html; charset=UTF-8">
<TITLE>暫定あぷ</TITLE>
<STYLE>
A{text-decoration:none;}
A:link{text-decoration:none;}
A:hover{color:red;}
</STYLE>
</HEAD>
<body bgcolor="#004040" text="#ffffff" link="#eeffee" vlink="#dddddd" alink="#ff0000">
<table width="100%"><tr><td bgcolor="#008080"><strong><font size="4">暫定あぷ</font></strong></td></tr></table>
<p>違法なファイルなどはご遠慮下さいヽ(´ー｀)ノ</p>
<?php
/* 以下オリジナルコードそのまま */

$foot = <<<FOOT
<BR><H5 align="right">
<a href="http://zurubon.strange-x.com/uploader/">ずるぽんあぷろだ</a> + <a href="http://php.loglog.jp/bbs/bbs5.php" target="_top">ﾚｯﾂ PHP!</A>(<a href="http://zantei.php.xdomain.jp/arc/up.zip" target="_top">source</A>) <img src="http://zantei.php.xdomain.jp/ztflag.php?up" alt="暫"><BR>
</H5>
</BODY>
</HTML>
FOOT;

function FormatByte($size){//バイトのフォーマット（B→kB）
  if($size == 0)			$format = "";
  else if($size <= 1024)		$format = $size."B";
  else if($size <= (1024*1024))		$format = sprintf ("%dkB",($size/1024));
  else if($size <= (10*1024*1024))	$format = sprintf ("%.2fMB",($size/(1024*1024)));
  else					$format = $size."B";

  return $format;
}
function paging($page, $total){//ページリンク作成
  global $PHP_SELF,$page_def;

    for ($j = 1; $j * $page_def < $total+$page_def; $j++) {
      if($page == $j){//今表示しているのはﾘﾝｸしない
        $next .= "[ <b>$j</b> ]";
      }else{
        $next .= sprintf("[<a href=\"%s?page=%d\">%d</a>]", $PHP_SELF,$j,$j);//他はﾘﾝｸ
      }
    }
    if($page=="all") return sprintf ("Page: %s [ALL]",$next,$PHP_SELF);
    else return sprintf ("Page: %s [<a href=\"%s?page=all\">ALL</a>]",$next,$PHP_SELF);
}
function error($mes1,$mes2=""): never{//えっらーﾒｯｾｰｼﾞ
  global $foot;

  echo "<hr><center>
<strong>$mes1</strong><br>
<p>$mes2</p></center>";
  echo $foot;
  exit;
}
/* start */
$limitb = $limitk * 1024;
$host = @gethostbyaddr($REMOTE_ADDR);
if(!$upcook) $upcook=implode(",",[$f_act,$f_com,$f_size,$f_mime,$f_date,$f_anot,$f_orig]);
[$c_act, $c_com, $c_size, $c_mime, $c_date, $c_anot, $c_orig]=explode(",",(string) $upcook);

/* アクセス制限 */
if(is_array($denylist)){
  foreach ($denylist as $line) {
      if(strstr($host, $line)) error('アクセス制限','あなたにはアクセス権限がありません。');
  }
}
/* 削除実行 */
if($delid && $delpass!=""){
  $old = file($logfile);
  $find = false;
  for($i=0; $i<count($old); $i++){
    [$did, $dext, , , , , , $dpwd, ]=explode("\t",$old[$i]);
    if($delid==$did){
      $find = true;
      $del_ext = $dext;
      $del_pwd = rtrim($dpwd);
    }else{
      $new[] = $old[$i];
    }
  }
  if(!$find) error('削除エラー','該当ファイルが見つかりません');
  if($delpass == $admin || substr(md5($delpass), 2, 7) == $del_pwd){
    if(file_exists($updir.$prefix.$delid.".$del_ext")) unlink($updir.$prefix.$delid.".$del_ext");

    $fp = fopen($logfile, "w");
    flock($fp, 2);
    fputs($fp, implode("",$new));
    fclose($fp);
  }else{
    error('削除エラー','パスワードが違います');
  }
}
/* 削除フォーム */
if($del){
  error("投稿データ削除","
<form action=$PHP_SELF method=\"POST\">
<input type=hidden name=delid value=\"".htmlspecialchars((string) $del)."\">
パスワード入力：<input type=password size=12 name=delpass>
<input type=submit value=\"削除\"></form>");
}
/* 環境設定フォーム */
if($act=="env"){
  echo "
<hr>
<strong>環境設定</strong><br>
<form method=GET action=\"$PHP_SELF\">
<input type=hidden name=act value=\"envset\">
<ul>
<li><strong>表示設定</strong>
<ul>
<input type=checkbox name=acte value=checked $c_act>ACT<br>
<input type=checkbox name=come value=checked $c_com>COMMENT<br>
<input type=checkbox name=sizee value=checked $c_size>SIZE<br>
<input type=checkbox name=mimee value=checked $c_mime>MIME<br>
<input type=checkbox name=datee value=checked $c_date>DATE<br>
<input type=checkbox name=orige value=checked $c_orig>ORIG<br>
</ul>
<li><strong>動作設定</strong>
<ul>
<input type=checkbox name=anote value=checked $c_anot>ファイルを開く時は別窓で開く<br>
</ul>
<br>
cookieを利用しています。<br>
上記の設定で訪問することができます。<br><br>
<input type=submit value=\"登録\">
<input type=reset value=\"元に戻す\">
</form>
<a href=\"$PHP_SELF\">戻る</a>
";
echo $foot;
exit;
}
$lines = file($logfile);
/* アプロード書き込み処理 */
if(file_exists($upfile) && $com && $upfile_size > 0){
  if(strlen((string) $com) > $commax) error('投稿エラー','コメントが長すぎます');
  if($upfile_size > $limitb)        error('投稿エラー','ファイルがデカすぎます');
  /* 連続投稿制限 */
  if($last_time > 0){
    $now = time();
    $last = @fopen($last_file, "r+") or die("連続投稿用ファイル $last_file を作成してください");
    $lsize = fgets($last, 1024);
    [$ltime, $lip] = explode("\t", $lsize);
    if($host == $lip && $last_time*60 > ($now-$ltime)){
      error('連続投稿制限中','時間を置いてやり直してください');
    }
    rewind($last);
    fputs($last, "$now\t$host\t");
    fclose($last);
  }
  /* 拡張子と新ファイル名 */
  $pos = strrpos((string) $upfile_name,".");	//拡張子取得
  $ext = substr((string) $upfile_name,$pos+1,strlen((string) $upfile_name)-$pos);
  $ext = strtolower($ext);//小文字化
  if(!in_array($ext, $arrowext))
    error("拡張子エラー","その拡張子ファイルはアップロードできません");
  /* 拒否拡張子はtxtに変換
  for($i=0; $i<count($denyext); $i++){
    if(strstr($ext,$denyext[$i])) $ext = 'txt';
  }
  */
  [$id, ] = explode("\t", $lines[0]);//No取得
  $id = sprintf("%03d", ++$id);		//インクリ
  $newname = $prefix.$id.".".$ext;

  /* 自鯖転送 */
  move_uploaded_file($upfile, $updir.$newname);//3.0.16より後のバージョンのPHP 3または 4.0.2 後
  //copy($upfile, $updir.$newname);
  chmod($updir.$newname, 0604);

  /* MIMEタイプ */
  if(!$upfile_type) $upfile_type = "text/plain";//デフォMIMEはtext/plain

  /* コメント他 */
  $com = htmlspecialchars((string) $com);	//タグ変換
  if(get_magic_quotes_gpc()) $com = stripslashes($com);	//￥除去
  $com = str_replace(["\0","\t","\r","\n","\r\n"], "", $com);//改行除去

  $now = gmdate("Y/m/d(D)H:i", time()+9*60*60);	//日付のフォーマット
  $pwd = ($pass) ? substr(md5($pass), 2, 7) : "*";	//パスっ作成（無いなら*）

  $dat = implode("\t", [$id,$ext,$com,$host,$now,$upfile_size,$upfile_type,$pwd,$upfile_name,]);

  if(count($lines) >= $logmax){		//ログオーバーならデータ削除
    for($d = count($lines)-1; $d >= $logmax-1; $d--){
      [$did, $dext, ]=explode("\t", $lines[$d]);
      if(file_exists($updir.$prefix.$did.".".$dext)) {
        unlink($updir.$prefix.$did.".".$dext);
      }
    }
  }

  $fp = fopen ($logfile , "w");		//書き込みモードでオープン
  flock($fp ,2);
  fputs ($fp, "$dat\n");		//先頭に書き込む
  for($i = 0; $i < $logmax-1; $i++)	//いままでの分を追記
    fputs($fp, $lines[$i]);
  fclose ($fp);
  reset($lines);
  $lines = file($logfile);		//入れなおし
}
foreach($arrowext as $list) $arrow .= $list." ";
/* 投稿フォーム */
echo '
<FORM METHOD="POST" ENCTYPE="multipart/form-data" ACTION="'.$PHP_SELF.'" >
アプするファイル<strong>（'.$limitk.' KBまで）</strong><br>
<INPUT TYPE="hidden" name="MAX_FILE_SIZE" value="'.$limitb.'">
<INPUT TYPE=file  SIZE="40" NAME="upfile"> 
Del Pass: <INPUT TYPE=password SIZE="10" NAME="pass" maxlength="10"><br>
コメント<i><small>（※コメント無記入の場合リロードになります/URLはオートリンクします）</small></i><br>
<INPUT TYPE=text SIZE="45" NAME="com">
<INPUT TYPE=submit VALUE="Up/Reload"><INPUT TYPE=reset VALUE="Cancel"><br>
<small>UP可能拡張子：'.$arrow.'</small>
</FORM>
';
/* カウンタ */
echo "<small>$count_start から ";
if(file_exists($count_file)){
  $fp = fopen($count_file,"r+");//読み書きモードでオープン
  $count = fgets($fp, 64);	//64バイトorEOFまで取得、カウントアップ
  $count++;
  fseek($fp, 0);			//ポインタを先頭に、ロックして書き込み
  flock($fp,2);
  fputs($fp, $count);
  fclose($fp);			//ファイルを閉じる
  echo $count;			//カウンタ表示
}
/* モードリンク */
echo '
（こわれにくさレベル1）D：投稿記事削除</small>
<HR size=1><small><a href="'.$PHP_SELF.'?act=env">環境設定</a> | <a href=?>リロード</a> |
　<a href="sam.php">画像一覧</a>
</small>
<HR size=1>
';
/* ログ開始位置 */
$st = ($page) ? ($page - 1) * $page_def : 0;
if(!$page) $page = 1;
if($page == "all"){
  $st = 0;
  $page_def = count($lines);
}
echo paging($page, count($lines));//ページリンク
//メインヘッダ
echo "<HR><table><tr>";
if($c_act) echo "<th>DEL</th>";
echo "<th>NAME</th>";
if($c_com) echo "<th>COMMENT</th>";
if($c_size) echo "<th>SIZE</th>";
if($c_mime) echo "<th>MIME</th>";
if($c_date) echo "<th>DATE</th>";
if($c_orig) echo "<th>ORIG</th>";
echo "</tr>";
//メイン表示
for($i = $st; $i < $st+$page_def; $i++){
  if($lines[$i]=="") continue;
  [$id, $ext, $com, $host, $now, $size, $mtype, $pas, $orig, ]=explode("\t",$lines[$i]);
  $fsize = FormatByte($size);
  if($auto_link) $com = preg_replace("#(https?|ftp|news)(:\\/\\/[[:alnum:]\\\\\\+\\\$\\\\;\\\\\\?\\\\\\.%,!\\\\#~\\*\\/:@&=_\\-]+)#m","<a href=\"\\1\\2\" target=\"_blank\">\\1\\2</a>",$com);

  $filename = $prefix.$id.".$ext";
  $target = $updir.$filename;

  if($c_anot) $jump = "target='_new'";
  #echo "<tr><!--$host-->";//ホスト表示
  echo "<tr>";//ホスト表示
  if($c_act) echo "<td><small><a href='$PHP_SELF?del=$id'>D</a></small></td>";
  echo "<td>[<a href='$target' $jump>$filename</a>]</td>";
  if($c_com) echo "<td><font size=2>$com</font></td>";
  if($c_size) echo "<td align=right><b><font size=2>$fsize</font></b></td>";
  if($c_mime) echo "<td><font size=2 color=888888>$mtype</font></td>";
  if($c_date) echo "<td><font size=2>$now</font></td>";
  if($c_orig) echo "<td><font size=2 color=aaaaaa>$orig</font></td>";
  echo "</tr>\n";
  }

echo "</table><HR>";
echo paging($page,count($lines));
echo $foot;
?>

