<?php

  # 「*」マークの項目は変更または確認が必要です

/* Common settings */
$CONF = array(

  #------------------------- URLなど -------------------------

  'CGIURL' => './bbs.php',      # * 掲示板スクリプトのURL（相対パスも可）
  'REFCHECKURL' => '',      # 掲示板スクリプトのURL（リファラチェックのための完全なURLを記述します。空の場合はチェックされません）
  'BBSHOST' => '',      # スクリプトがインストールされるホストアドレス（呼び出し元のチェック用。空の場合はチェックされません）

  #------------------------- 掲示板名等 -------------------------

  'LOGFILENAME' => './bbs.log',   # ログファイル名
  'OLDLOGFILEDIR' => './log/',    # ログを保存するディレクトリ名（末尾に / を付けてください。空の場合、ログは保存されません）
  'ZIPDIR' => '',       # 過去のログファイルを保存するZIPアーカイブディレクトリ（末尾に/を付けてください。空の場合、またはgzcompressが利用できない場合は、ZIPアーカイブは作成されません）

  # ----HTML テンプレートファイル名----
  'TEMPLATE' => './sub/template.html',
  'TEMPLATE_ADMIN' => './sub/tmpladmin.html',
  'TEMPLATE_LOG' => './sub/tmpllog.html',
  'TEMPLATE_TREEVIEW' => './sub/tmpltree.html',

  #------------------------- 掲示板名等 -------------------------

  'BBSTITLE' => 'あやしいわーるど＠***',           # * 掲示板名
  ## TL注: あやしいわーるどのタイトルは通常「あやしいわーるど@[ウェブホスト名]」の形式をとります
  'INFOPAGE' => './bbs.php',   # * 広報室のURL（ホーム/情報ページ）

  #------------------------- 管理者設定 -------------------------

  'ADMINNAME' => '管理人',                               # * 管理者名
  'ADMINMAIL' => 'admin@example.com',                # * 管理者のメールアドレス
  'ADMINPOST' => '',   # * 管理者パスワード（暗号化されたパスワード。最初は空のままにしておいてください）
  'ADMINKEY' => '',         # * 管理者モードに入るためのキーワード（通常の英数字を推奨。空の場合、管理者モードは利用できません）

  ## TL ノート: 掲示板が起動して実行された後に管理者モードに入るには、投稿フォームの名前とコンテンツのフィールドに adminkey (adminkey のみ) を入力して、送信をクリックします。
  ## 名前フィールドに adminkey (adminkey のみ) を入力すると、投稿に管理者キャップコードが表示されます。

  # 検索エンジンに掲示板の概要を伝えます。簡潔で分かりやすいものにしましょう

  # 掲示板に関連する単語をカンマで区切って入力してください。多すぎると検索エンジンからペナルティを受ける可能性があります。
  'META_DESCRIPTION' => 'This is the "あやしいわーるど＠***" bulletin board',

  # Enter some words related to the bulletin board, seperated by commas. If there's too many, you may be penalized by search engines
  'META_KEYWORDS' => 'AyashiiWorld,AyaWa,StrangeWorld,Ayashii,ᵃʸᵃˢʰⁱⁱ,strange,bulletin,board,BBS',

  # コンテンツの言語を指定してください。通常は日本語 (ja) を使用します。
  ## TL ノート: Ayashii World スタイルの AA (ASCII アート) は、フォントを MS Gothic または他の互換性のあるフォントに変更するための追加の CSS がないと、英語 (en) では正しくレンダリングされない可能性があります。
  # 日本語 : ja
  # 英語 : en
  'META_LANGUAGE' => 'ja',

  #------------------------- 操作設定 -------------------------

  # 掲示板への投稿機能を停止する
  # (ログを読むことはできますが、投稿することはできません)
  # 0 : 無効
  # 1 : 有効
  'RUNMODE' => 0,

  # 画像アップロード機能。
  # 0 : 無効
  # 1 : 有効
  'BBSMODE_IMAGE' => 0,

  # 管理者のみの投稿モード（日記用）
  # 0 : 無効
  # 1 : 管理者のみが新規投稿を許可され、フォローアップ投稿は許可されません
  # 2 : 管理者のみが新規投稿を許可され、フォローアップ投稿は許可されます
  'BBSMODE_ADMINONLY' => 0,

  # UNDO機能の使い方（最新の投稿を削除できる機能）
  # 0 : 無効
  # 1 : 有効
  'ALLOW_UNDO' => 1,

  # [0]と[未読]ボタンを表示する
  # (掲示板の投稿があまり活発でない場合は、これは必要ありません)
  # 0 : 表示しない
  # 1 : 表示する
  'SHOW_READNEWBTN' => 1,

  # gzip圧縮のデフォルト値
  # (ページのレンダリングを高速化します)
  # 0 : 圧縮なし
  # 1 : 圧縮あり
  'GZIPU' => 1,

  # メッセージの保存数
  'LOGSAVE' => 5000,

  # １画面に表示するメッセージの表示数
  'MSGDISP' => 40,

  # 二重書き込みチェック件数
  ## 'CHECKCOUNT' => 20,
  'CHECKCOUNT' => 0,

  # １メッセージの最大桁数
  'MAXMSGCOL' => 250,

  # １メッセージの最大行数
  'MAXMSGLINE' => 120,

  # 名前フィールドの最大文字数
  'MAXNAMELENGTH' => 128,

  # メールフィールドの最大文字数
  'MAXMAILLENGTH' => 256,

  # タイトルフィールドの最大文字数
  'MAXTITLELENGTH' => 128,

  # 1つのメッセージの最大サイズ（バイト）
  'MAXMSGSIZE' => 9000,

  # 最小投稿間隔（秒）
  ## 'MINPOSTSEC' => 2,
  'MINPOSTSEC' => 0,

  # 最大投稿間隔（秒）
  ## 'MAXPOSTSEC' => 1,
  'MAXPOSTSEC' => 0,

  # 自動リンク機能のデフォルト値
  # 0 : 無効
  # 1 : 有効
  'AUTOLINK' => 1,

  # フォローアップ投稿画面表示
  # 0 : 新しいウィンドウを開いて表示する（リバース型設定）
  # 1 : 同一画面に表示（本店型設定）
  'FOLLOWWIN' => 0,

  # ユーザーのIPアドレスを記録する
  # 0 : 記録しない
  # 1 : 匿名プロキシのみを記録する
  # 2 : すべてを記録する
  'IPREC' => 2,

  # ユーザーエージェント（ブラウザ名）を記録する
  # 0 : 無効
  # 1 : 有効
  'UAREC' => 1,

  # ユーザーのIPアドレスを表示する（非推奨）
  # (ユーザーのIPアドレス記録を有効にする必要があります)
  # 0 : 無効
  # 1 : 有効
  'IPPRINT' => 0,

  # ユーザーエージェント（ブラウザ名）を表示
  # (ユーザーエージェントの記録を有効にする必要があります)
  # 0 : 無効
  # 1 : 有効
  'UAPRINT' => 0,

  # 同じIPアドレスからの投稿を拒否する時間（秒）
  # (ユーザーのIPアドレス記録を有効にする必要があります
  # 0に設定すると、ユーザーはminpostsec設定によって制限されます)
  'SPTIME' => 0,

  # 名前/メールアドレスを記憶するためにCookieを使用する
  # 0 : 無効
  # 1 : 有効
  'COOKIE' => 1,

  # 簡単な自己返信防止機能を使用する
  # (返信者と返信受信者のIPアドレスが同じ場合、返信の名前欄に(自己返信)と表示されます。
  # ユーザーのIPアドレス記録を有効にする必要があります)
  # 0 : 無効
  # 1 : 有効
  'SHOW_SELFFOLLOW' => 1,

  #------------------------- カウンター等 -------------------------

  # * カウンター開始日
  'COUNTDATE' => '2025/11/08',

  # カウンターのファイル名の最初の部分
  'COUNTFILE' => './count/count',

  # カウンター破損耐性レベル
  # (3～5の値が推奨されます。値が大きいほどカウンターのエラーは少なくなりますが、サーバーの負荷は大きくなります)
  'COUNTLEVEL' => 5,

  # File name for real-time participant counting
  #  (Leave it empty if you don't want to use the real-time participant counting function)
  'CNTFILENAME' => './bbs.cnt',

  # リアルタイム参加者カウントのファイル名
  # (リアルタイム参加者カウント機能を使用しない場合は空白のままにしてください)
  'CNTLIMIT' => 300,

  #------------------------- 時間 -------------------------

  # ホストサーバーの場所と日本（またはあなたの国）の時差
  # 日本 : 0
  # グリニッジ標準時 : -9
  # アメリカ：-14（ワシントン）
  # : -20 (ミッドウェー諸島)
  # ニュージーランド : 3
  'DIFFTIME' => 0,

  # 時間差（秒単位）（微調整用。負の値も可）
  'DIFFSEC' => 0,

  #------------------------- 色設定（16進数）など ------------------------

  # 背景色
  # クラシック : 007f7f (ティール)
  # REBIRTH型 : 004040（黒板）
  #本店型 : 303c6d（藍）
  'C_BACKGROUND' => '004040',

  'C_TEXT' => 'efefef',  # テキストの色

  # リンクの色
  'C_A_COLOR' => 'cfe',    # 通常
  'C_A_VISITED' => 'ddd',  # 訪問済み
  'C_A_ACTIVE' => 'f00',   # アクティブ
  'C_A_HOVER' => '1ee',    # ホバー(マウスオーバー)
                           
  'C_SUBJ' => 'fffffe',    # タイトルの色
  'C_QMSG' => 'ccc',       # 引用メッセージの色（色を変えない場合は空にしてください）
  'C_ERROR' => 'f00',      # エラーメッセージの色

  'TXTFOLLOW' => '■',    # フォロー投稿画面ボタンに表示する文字
  'TXTAUTHOR' => '★',    # 投稿者検索ボタンに表示する文字
  'TXTTHREAD' => '◆',    # スレッド表示ボタンに表示する文字
  'TXTTREE' => '木',      # ツリー表示ボタンに表示する文字
  'TXTUNDO' => '×',      # UNDO(自分が直前に投稿した記事のみ消去)ボタンに表示する文字

  'FSUBJ' => '',          # フォロー投稿時に相手の投稿者名に付加する文字（一般の掲示板では「さん」などを付けると良いでしょう）
  'ANONY_NAME' => '　',   # 匿名の投稿者名（一般の掲示板では「匿名」、「名無し」などを付けると良いでしょう）

  #------------------------- メッセージログ -------------------------

  # 過去ログの保存形式
  # (HTML形式にすると過去ログ検索が利用できなくなります)
  #   0 : HTML形式
  #   1 : バイナリ形式
  'OLDLOGFMT' => 1,

  # 過去ログからのフォロー投稿・投稿者検索
  # (過去ログがバイナリ形式の場合のみ有効)
  #   0 : 不可
  #   1 : 可
  'OLDLOGBTN' => 1,

  # 過去ログの保存方法
  #   0 : 日毎
  #   1 : 月毎
  'OLDLOGSAVESW' => 1,

  # 過去ログの保存日数
  #  (過去ログの保存方法が日毎の場合にのみ有効)
  'OLDLOGSAVEDAY' => 12,

  # 過去ログの最大ファイルサイズ
  'MAXOLDLOGSIZE' => 4 * 1024 * 1024,

  #------------------------- 表示テンプレートなど -------------------------

  # * リンク行
  'BBSLINK' => '
<!-- Example:  |  <a href="http://strange.egoism.jp/script/" target="_blank">KuzuhaScriptPHP</a> -->
| <a href="https://qptn.shop/" target="_blank">能登川</a> 
| <a href="https://dis.heyuri.net/sw/" target="_blank">heyuri</a>
',

  # メッセージテンプレート
#  'TMPL_MSG' => '
#<div class="m" id="m{val postid}">
#  {val postid}<span class="nw"><span class="ms">{val title}</span>&nbsp;&nbsp;<span class="mu">User: <span class="mun">{val user}</span></span>&nbsp;
#  &nbsp;<span class="md">Post date: {val wdate}<a id="a{val postid}">&nbsp;</a>
#  {val btn}</span></span>
#  <blockquote>
#    <pre>{val msg}</pre>
#  </blockquote>
#{val envlist}</div>
#
#<hr /><!--  -->
#',

  # 環境変数表示テンプレート
#  'TMPL_ENVLIST' => "<div class=\"env\">{val envaddr}{val envbr}{val envua}</div>\n",

  #------------------------- アクセス制限など -------------------------

  # 投稿禁止ホスト名パターンリスト(Perl5互換正規表現)
  'HOSTNAME_POSTDENIED' => array(
    #Example: 'npa\.go\.jp$', */
      '.example.com',
      '.example.net'
  ),

  # アクセス禁止ホスト名パターンリスト(Perl5互換正規表現)
  'HOSTNAME_BANNED' => array(
    #Example: '\.npa\.go\.jp$',
  ),

  # アクセス禁止エージェント名パターンリスト(Perl5互換正規表現) 20230818 猫・新規追加
  'HOSTAGENT_BANNED' => array(
    #例# 'iPad$',
  'dummy',
  ),

  # 投稿禁止ワード
  'NGWORD' => array(
  # Example: 'Viagra','casino'
    'viagra',
    'Viagra',
    'スーパーコピー'
  ),

  # モバイルモジュールからの投稿をモバイルデバイスのIPで制限するかどうか
  # モバイル版の投稿機能では保護コードの同一IPアドレスのチェックが行われないため、
  # モバイルデバイスの IP アドレスで制限することをお勧めします。
  # (iモード等でサイトにアクセスするたびにIPアドレスが変わるため)
  'RESTRICT_MOBILEIP' => 0,

  #------------------------- 固定ハンドル名 -------------------------

  # 'ハンドル名' => 'パスワード',
  # の形式で羅列してください。パスワードはそのまま記述してください。
  # 投稿者名欄にパスワードを記述して投稿すると、ハンドル名に変換されます。
  # 投稿者名欄にハンドル名をそのまま記述して投稿すると、「（騙り）」が付加されます。
  'HANDLENAMES' => array(
    'しぱ' => 'しば',
    '騙り' => '管理人',
  ),

  #------------------------- 詳細設定（通常は変更不要です） -------------------------

  'SHOW_COUNTER' => 1,  # カウンターの表示有無
  'DATEFORMAT' => '',  # 時刻表示フォーマット

  #------------------------- デバッグ -------------------------

  'SHOW_PRCTIME' => 1,  # 実行時間の表示
);
?>
