<?php

  # "*"がついている項目は変更・確認が必要です。

/* 共通設定 */
$CONF = [

  #------------------------- URLなど -------------------------

  'CGIURL' => './bbs.php',      # * 掲示板スクリプトのURL（相対パス可）
  'REFCHECKURL' => '',      # 掲示板スクリプトのURL（Refererチェック用、フルURLを記述。空にするとチェックしません）
  'BBSHOST' => '',      # スクリプトを設置するホストアドレス（呼び出し元チェック用。空にするとチェックしません）

  #------------------------- ファイルとディレクトリ -------------------------

  'LOGFILENAME' => './bbs.log',   # ログファイル名
  'OLDLOGFILEDIR' => './log/',    # 過去ログ保存用ディレクトリの名前（最後に/を入れてください。空の場合は過去ログを保存しません）
  'ZIPDIR' => '',       # 過去ログファイルのZIPアーカイブディレクトリ（最後に/を入れてください。空の場合かgzcompress関数が使用不可の場合はZIPアーカイブを作成しません）

  # ----HTMLテンプレートファイル名----
  'TEMPLATE' => './sub/template.html',
  'TEMPLATE_ADMIN' => './sub/tmpladmin.html',
  'TEMPLATE_LOG' => './sub/tmpllog.html',
  'TEMPLATE_TREEVIEW' => './sub/tmpltree.html',

  #------------------------- 掲示板名称など -------------------------

  'BBSTITLE' => 'あやしいわーるど＠***',           # * 掲示板の名前
  'INFOPAGE' => './',   # * 広報室のURL

  #------------------------- 管理設定 -------------------------

  'ADMINNAME' => '管理人',                               # * 管理人の名前
  'ADMINMAIL' => 'mail@example.com',                # * 管理人のメールアドレス
  'ADMINPOST' => '',   # * 管理用パスワード（暗号化パスワード。最初は空にしておいてください）
  'ADMINKEY' => '',         # * 管理モード移行用キーワード（半角英数字推奨、空の場合管理モードを使用できません）

  #------------------------- 検索エンジン -------------------------

  # 検索エンジンに掲示板の概要を教えます。短い文章にするといいでしょう
  'META_DESCRIPTION' => '「あやしいわーるど＠***」の掲示板です',

  # 掲示板に関連した単語をカンマ区切りで入力します。あまり多すぎるとペナルティを食らう場合もあります
  'META_KEYWORDS' => 'あやしいわーるど,あやわー,strangeworld,あやしい,ぁゃιぃ,strange',

  # コンテンツの言語を指定してください。通常は日本語(ja)
  # 日本語：ja
  # English：en
  'META_LANGUAGE' => 'ja',

  #------------------------- 動作設定 -------------------------

  # 掲示板投稿機能停止
  #（ログは読めますが、投稿が一切できなくなります。）
  #   0 : 無効
  #   1 : 有効
  'RUNMODE' => 0,

  # 画像のアップロード機能
  #   0 : 無効
  #   1 : 有効
  'BBSMODE_IMAGE' => 0,

  # 管理者専用投稿モード（日記用）
  #   0 : 無効
  #   1 : 管理者による新規投稿のみ許可し、一切のフォロー投稿を許可しない
  #   2 : 新規投稿は管理者のみ許可し、フォロー投稿は誰でも許可する
  'BBSMODE_ADMINONLY' => 0,

  # UNDO機能（自分が直前に投稿した記事のみ消去できる機能）の使用
  #   0 : 無効
  #   1 : 有効
  'ALLOW_UNDO' => 1,

  # 「0件」ボタンと「未読」ボタンの表示
  # （投稿数の少ない掲示板であれば必要ないでしょう）
  #   0 : 表示しない
  #   1 : 表示する
  'SHOW_READNEWBTN' => 1,

  # gzip圧縮の初期値
  # （表示が高速化されます）
  #   0 : 圧縮しない
  #   1 : 圧縮する
  'GZIPU' => 1,

  # メッセージの保存数
  'LOGSAVE' => 1000,

  # １画面に表示するメッセージの表示数
  'MSGDISP' => 40,

  # 二重書き込みチェック件数
  'CHECKCOUNT' => 20,

  # １メッセージの最大桁数
  'MAXMSGCOL' => 250,

  # １メッセージの最大行数
  'MAXMSGLINE' => 120,

  # １メッセージの最大サイズ(byte)
  'MAXMSGSIZE' => 9000,

  # 最短投稿間隔（秒数）
  'MINPOSTSEC' => 2,

  # 最長投稿間隔（秒数）
  'MAXPOSTSEC' => 1,

  # 自動リンク機能の初期値
  #   0 : 無効
  #   1 : 有効
  'AUTOLINK' => 1,

  # フォロー投稿画面表示
  #   0 : 新規ウィンドウをオープンして表示(Rebirth)
  #   1 : 同一画面に表示(本店)
  'FOLLOWWIN' => 0,

  # 投稿者IPアドレスの記録
  #   0 : 記録しない
  #   1 : 匿名プロクシのみ記録
  #   2 : 全て記録
  'IPREC' => 2,

  # User Agent(ブラウザ名)の記録
  #   0 : 無効
  #   1 : 有効
  'UAREC' => 1,

  # 投稿者IPアドレスの表示(非推奨)
  # （投稿者IPアドレスの記録が有効になっている必要があります）
  #   0 : 無効
  #   1 : 有効
  'IPPRINT' => 0,

  # User Agent(ブラウザ名)の表示
  # （User Agentの記録が有効になっている必要があります）
  #   0 : 無効
  #   1 : 有効
  'UAPRINT' => 0,

  # 同一IPアドレスからの投稿を拒否する時間 (秒)
  # （投稿者IPアドレスの記録が有効になっている必要があります
  #   0に設定するとminpostsecの設定により制限を行います）
  'SPTIME' => 0,

  # Cookieによる投稿者／メールアドレス記憶機能の使用
  #   0 : 無効
  #   1 : 有効
  'COOKIE' => 1,

  # 簡易自作自演防止機能の使用
  # （返信元と返信先のIPアドレスが同一の場合に名前欄に(自己レス)と表示する機能
  #   投稿者IPアドレスの記録が有効になっている必要があります）
  #   0 : 無効
  #   1 : 有効
  'SHOW_SELFFOLLOW' => 1,

  #------------------------- カウンターなど -------------------------

  # * カウンターのスタート日付
  'COUNTDATE' => '2021/07/03',

  # カウンターのファイル名の先頭部分
  'COUNTFILE' => './count/count',

  # カウンターの壊れにくさレベル
  #  (推奨値2～5 値が大きいほどエラーが発生しにくくなりますがサーバー負荷が大きくなります)
  'COUNTLEVEL' => 4,

  # リアルタイム参加者カウント用ファイル名
  #  (リアルタイム参加者カウント機能を使用しない場合は空のままにしておきます)
  'CNTFILENAME' => './bbs.cnt',

  # リアルタイム参加者カウント間隔 (秒)
  # （最終ページビューからこの時間を超えた参加者は集計から除外されます）
  'CNTLIMIT' => 300,

  #------------------------- 時間 -------------------------

  # サーバー設置場所と日本との時差
  #   日本             : 0
  #   グリニッジ標準時 : -9
  #   アメリカ         : -14 (ワシントン)
  #                    : -20 (ミッドウェー諸島)
  #   ニュージーランド : 3
  'DIFFTIME' => 0,

  # 秒数時差（微調整用、マイナス値可）
  'DIFFSEC' => 0,

  #------------------------- 色の設定(16進で指定)など -------------------------

  # 背景色
  # クラシック：007f7f (Teal)
  # Rebirth系：004040 (黒板)
  # 本店：303c6d (蔵藍)
  'C_BACKGROUND' => '004040',

  'C_TEXT' => 'efefef',  # テキスト色

  # リンク色
  'C_A_COLOR' => 'cfe',    # 通常
  'C_A_VISITED' => 'ddd',  # 訪問済み
  'C_A_ACTIVE' => 'f00',   # アクティブ
  'C_A_HOVER' => '1ee',    # ホバー(マウスオーバー)

  'C_SUBJ' => 'fffffe',   # 題名の色
  'C_QMSG' => 'ccc',   # 引用メッセージの色（色を変えない場合は空にしてください）
  'C_ERROR' => 'f00',  # エラーメッセージの色

  'TXTFOLLOW' => '■',    # フォロー投稿画面ボタンに表示する文字
  'TXTAUTHOR' => '★',    # 投稿者検索ボタンに表示する文字
  'TXTTHREAD' => '◆',    # スレッド表示ボタンに表示する文字
  'TXTTREE' => '木',      # ツリー表示ボタンに表示する文字
  'TXTUNDO' => '消',      # UNDO(自分が直前に投稿した記事のみ消去)ボタンに表示する文字

  'FSUBJ' => '',          # フォロー投稿時に相手の投稿者名に付加する文字（一般の掲示板では「さん」などを付けると良いでしょう）
  'ANONY_NAME' => '　',   # 匿名の投稿者名（一般の掲示板では「匿名」、「名無し」などを付けると良いでしょう）

  #------------------------- 過去ログ -------------------------

  # 過去ログの保存形式
  # (HTML形式にすると過去ログ検索が利用できなくなります)
  #   0 : HTML形式
  #   1 : バイナリ形式
  'OLDLOGFMT' => 1,

  # 過去ログからのフォロー投稿・投稿者検索
  # (過去ログがバイナリ形式の場合のみ有効)
  #   0 : 不可
  #   1 : 可
  'OLDLOGBTN' => 1,

  # 過去ログの保存方法
  #   0 : 日毎
  #   1 : 月毎
  'OLDLOGSAVESW' => 1,

  # 過去ログの保存日数
  #  (過去ログの保存方法が日毎の場合にのみ有効)
  'OLDLOGSAVEDAY' => 30,

  # 過去ログの最大ファイルサイズ
  'MAXOLDLOGSIZE' => 4 * 1024 * 1024,

  #------------------------- 表示テンプレートなど -------------------------

  # * リンク行
  'BBSLINK' => '
<!-- 例:  |  <a href="http://strange.egoism.jp/script/" target="_blank">くずはすくりぷとPHP</a> -->
|| <a href="https://example.com/" target="_blank">example.com</a> |
 <a href="https://example.net/" target="_blank">example.net</a>
',

  # メッセージテンプレート
#  'TMPL_MSG' => '
#<div class="m" id="m{val postid}">
#  {val postid}<span class="nw"><span class="ms">{val title}</span>&nbsp;&nbsp;<span class="mu">投稿者：<span class="mun">{val user}</span></span>&nbsp;
#  &nbsp;<span class="md">投稿日：{val wdate}<a id="a{val postid}">&nbsp;</a>
#  {val btn}</span></span>
#  <blockquote>
#    <pre>{val msg}</pre>
#  </blockquote>
#{val envlist}</div>
#
#<hr /><!--  -->
#',

  # 環境変数表示テンプレート
#  'TMPL_ENVLIST' => "<div class=\"env\">{val envaddr}{val envbr}{val envua}</div>\n",

  #------------------------- アクセス制限など -------------------------

  # 投稿禁止ホスト名パターンリスト(Perl5互換正規表現)
  'HOSTNAME_POSTDENIED' => [
    #例: 'npa\.go\.jp$', */
      '.example.com',
  ],

  # アクセス禁止ホスト名パターンリスト(Perl5互換正規表現)
  'HOSTNAME_BANNED' => [
    #例: '\.npa\.go\.jp$',
  ],

  # 投稿禁止ワード
  'NGWORD' => [
  #例: 'Viagra','スーパーコピー','<a href='
  ],

  # 携帯モジュールからの投稿を携帯端末のIPで制限するか否か
  # 携帯版の投稿機能はプロテクトコードの同一IPアドレスチェックをしていないため、
  # 携帯端末のIPアドレスによる制限を推奨します。
  # (iモードなどではアクセスの度にIPアドレスが変わるため)
  'RESTRICT_MOBILEIP' => 0,

  #------------------------- 固定ハンドル名 -------------------------

  # 'ハンドル名' => 'パスワード',
  # の形式で羅列してください。パスワードはそのまま記述してください。
  # 投稿者名欄にパスワードを記述して投稿すると、ハンドル名に変換されます。
  # 投稿者名欄にハンドル名をそのまま記述して投稿すると、「（騙り）」が付加されます。
  'HANDLENAMES' => [
    'しぱ' => 'しば',
    '騙り' => '管理人',
  ],

  #------------------------- 詳細設定（通常は変更不要です） -------------------------

  'SHOW_COUNTER' => 1,  # カウンターの表示有無
  'DATEFORMAT' => '',  # 時刻表示フォーマット

  #------------------------- デバッグ -------------------------

  'SHOW_PRCTIME' => 1,  # 実行時間の表示
];
?>
